 ; Ŀ
 ;   Hatch - cable tray/area class hatch installers.                       
 ;   Copyright 1996, 1997, 2002, 2004, 2005, 2010 by Rocket Software Ltd.  
 ;   You may not be trying to accomplish what you think you are.           
 ; 

 ; Ŀ
 ;   Hatche                                                                
 ; 
 (DEFUN HATCHE (ansi laynam laycol scal / *error* ss hasc clay)
  (setvar "cmdecho" 0)
  (command "undo" "M")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (if clay (setvar "clayer" clay))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Decide on a scale and the current layer.                              
 ; 
  (setq hasc (* (misps) scal))
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" laynam)
      (setvar "clayer" laynam)
      (command "layer" "m" laynam "c" laycol "" ""))
  (setq ss (ssget))
  (command "-bhatch" "p" ansi hasc "0" "s" ss "" "")
  (setvar "clayer" clay)
 (princ))
 ; Ŀ
 ;   Hatche end.                                                           
 ; 

 ; Ŀ
 ;   Thatch                                                                
 ; 
 (DEFUN C:THATCH ()
  (hatche "dots" "cable_tray" "1" 25)
 (princ))

 ; Ŀ
 ;   Xhatch                                                                
 ; 
 (DEFUN C:XHATCH ()
 ; Ŀ
 ;   The hatch pattern scale seems to change with each release.            
 ;   (They were 1 for 2002, if this needs to be restored.)                 
 ;   The distance between lines in Ansi31 and Ansi37 is currently 0.125,   
 ;   so if we want to print at about 1mm on 11" x 17" paper (which plots   
 ;   at about half of the correct scale) then want to print at 2 (because  
 ;   we are on 11 x 17) x 8 (to scale 0.125 to 1) x dimscale.              
 ;   So Dimscale x 16.                                                     
 ;   Dot and hex hatches use different but related scales.                 
 ; 
  (hatche "ansi37" "hatch" "6" 16)
 (princ))

 ; Ŀ
 ;   Slatch                                                                
 ; 
 (DEFUN C:SLATCH ()
  (hatche "ansi31" "hatch" "6" 16)
 (princ))

 ; Ŀ
 ;   Hexhch                                                                
 ; 
 (DEFUN C:HEXHCH ()
  (hatche "hex" "hatch" "6" 4)
 (princ))

(princ)
